/**
 * 
 */
package gov.va.med.mhv.usermgmt.util;

import java.io.IOException;

import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.tigris.atlas.config.ConfigurationManager;

import gov.va.med.mhv.core.util.DescriptionBuilder;
import gov.va.med.mhv.core.util.Precondition;
import gov.va.med.mhv.core.util.PropertiesUtil;

public class HelpDeskAlertProperties {

    private static final Log LOG = LogFactory.getLog(HelpDeskAlertProperties.
        class);
    
    private static final String DEFAULT_RESOURCE_NAME = 
        "helpdesk-alert.properties";

    private static final String RESOURCE_NAME = 
        "/" + DEFAULT_RESOURCE_NAME;

    private static final String ALERT_PREFIX = "helpdesk.alert.";
    
    private static final String EMAIL_ADDRESSS = "helpdesk.email.address";

    private static final String SUPPORT_EMAIL_ADDRESSS = 
    	"support.email.address";

    private static final String MERGE_PATIENTS_ALERT = "merge.patients";

    private static final HelpDeskAlertProperties instance = 
        new HelpDeskAlertProperties();

    /**
     * Returns a HelpDeskAlertProperties instance.
     * @return a HelpDeskAlertProperties instance.
     */
    public static final HelpDeskAlertProperties getInstance() {
        return instance;
    }
    
    private final String helpDeskEmailAddress;
    private final String supportEmailAddress;
    private final HelpDeskAlert mergePatientsAlert;
    
    private HelpDeskAlertProperties() {
        java.util.Properties properties = null;
        java.util.Properties defaultProperties = null;
        try {
            properties = ConfigurationManager.getConfiguration(
                RESOURCE_NAME);
        } catch (IllegalStateException e) {
            LOG.warn("Using defaults, because failed to load " +
                "properties from '" + RESOURCE_NAME + "'.");
        } 
        try {
            defaultProperties = new java.util.Properties();
            defaultProperties.load(getClass().getResourceAsStream(
                DEFAULT_RESOURCE_NAME));
        } catch (IOException e) {
            Precondition.fail("Failed to load default '" 
                + RESOURCE_NAME + "' properties.");
        }
        LOG.debug("properties: " + DescriptionBuilder.describe(properties));
        LOG.debug("default properties: " + DescriptionBuilder.describe(
            defaultProperties));
        
        helpDeskEmailAddress = getValue(EMAIL_ADDRESSS , properties, 
            defaultProperties);
        supportEmailAddress = getValue(SUPPORT_EMAIL_ADDRESSS , properties, 
                defaultProperties);
        mergePatientsAlert = getAlert(MERGE_PATIENTS_ALERT, properties, 
            defaultProperties, helpDeskEmailAddress);
    }

    public String getHelpDeskEmailAddress() {
        return helpDeskEmailAddress;
    }

    public String getSupportEmailAddress() {
        return supportEmailAddress;
    }

    public HelpDeskAlert createMergePatientsAlert() {
        return (HelpDeskAlert) mergePatientsAlert.clone();
    }

    private String getValue(String name, java.util.Properties properties, 
        java.util.Properties defaultProperties)
    {
        assert !StringUtils.isBlank(name);
        assert defaultProperties != null;
        return PropertiesUtil.getValue(RESOURCE_NAME, properties, name, 
            PropertiesUtil.getValue(DEFAULT_RESOURCE_NAME, defaultProperties, 
            name, null));
    }

    private HelpDeskAlert getAlert(String name, java.util.Properties properties, 
        java.util.Properties defaultProperties, String recipient)
    {
        final String prefix = ALERT_PREFIX + name + ".";
        return new HelpDeskAlert(name, getValue(prefix +  "subject.format", 
            properties, defaultProperties), getValue(prefix + 
            "message.format", properties, defaultProperties),
            recipient);
    }
    
}